/*
 *  libjdksmidi-2004 C++ Class Library for MIDI
 *
 *  Copyright (C) 2004  J.D. Koftinoff Software, Ltd.
 *  www.jdkoftinoff.com
 *  jeffk@jdkoftinoff.com
 *
 *  *** RELEASED UNDER THE GNU GENERAL PUBLIC LICENSE (GPL) April 27, 2004 ***
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//
// Copyright (C) 2010 V.R.Madgazin
// www.vmgames.com vrm@vmgames.com
//

#include "jdksmidi/world.h"
#include "jdksmidi/fileread.h"
#include "jdksmidi/fileshow.h"
using namespace jdksmidi;

#include <iostream>
using namespace std;

int main ( int argc, char **argv )
{
    if ( argc > 1 )
    {
        const char *infile_name = argv[1];

        MIDIFileReadStreamFile rs ( infile_name );
        if ( !rs.IsValid() )
        {
            cerr << "\nError opening file " << infile_name << endl;
            return -1;
        }

        // if true print META_SEQUENCER_SPECIFIC events as text string
        bool sqspecific_as_text = true;

        MIDIFileShow shower ( stdout, sqspecific_as_text );
        MIDIFileRead reader ( &rs, &shower );

        if ( !reader.Parse() )
        {
            cerr << "\nError parse file " << infile_name << endl;
            return -1;
        }
    }
    else
    {
        cerr << "usage:\n\tjdkmidi_test_show INFILE.mid\n";
        return -1;
    }

    return 0;
}
